<?php

namespace VM\ApiBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Security\Core\SecurityContext;

class SecurityController extends AbstractController
{

    /**
     * User login process
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function loginAction()
    {
        $request = $this->getRequest();
        $session = $request->getSession();


        $error = '';

        // get the login error if there is one
        if ($request->attributes->has(SecurityContext::AUTHENTICATION_ERROR)) {
            $error = $request->attributes->get(SecurityContext::AUTHENTICATION_ERROR);
        }
        elseif($session->has(SecurityContext::AUTHENTICATION_ERROR))
        {
            $error = 'Błędny login lub hasło';//.$session->get(SecurityContext::AUTHENTICATION_ERROR);
            $session->remove(SecurityContext::AUTHENTICATION_ERROR);
        }

        if(!empty($error))
        {
            $session->getFlashBag()->add('error', $error);
        }

        return $this->render(
            'VMFrontBundle:Security:login.html.twig',
            array(
                // last username entered by the user
                'last_username' => $session->get(SecurityContext::LAST_USERNAME),
//                'error'         => $error,
            )
        );
    }

    public function testAction()
    {
        echo "<pre>";
        print_r($this->get('security.context')->getToken()->getUser());
    }
}
